(**
 *
 *  Module:       dearcusq.pas
 *  Description:  DEARC unSqueezing routines (huffman encoding)
 *
 *  Revision History:
 *    7-26-88: unitized for Turbo v4.0
 *
**)


unit dearcusq;

interface

uses
  dearcglb,
  dearcabt,
  dearcio,
  dearcunp;

procedure init_usq;
function getc_usq : integer;


(*
 *  definitions for unsqueeze
 *)
Const
  ERROR   = -1;
  SPEOF   = 256;
  NUMVALS = 256;               { 1 less than the number of values }

Type
  nd = record
          child : array [0..1] of integer
        end;

Var
  node     : array [0..NUMVALS] of nd;
  bpos     : integer;
  curin    : integer;
  numnodes : integer;

implementation


(**
 *
 *  Name:         procedure init_usq
 *  Description:  initialize for unsqueeze
 *  Parameters:   none
 *
**)
procedure init_usq;
var
  i : integer;
begin
  bpos := 99;

  fread(numnodes, sizeof(numnodes));

  if (numnodes < 0) or (numnodes > NUMVALS) then
    abort('File has an invalid decode tree');

  node[0].child[0] := -(SPEOF + 1);
  node[0].child[1] := -(SPEOF + 1);

  for i := 0 to numnodes-1 do
    begin
      fread(node[i].child[0], sizeof(integer));
      fread(node[i].child[1], sizeof(integer))
    end
end; (* proc init_usq; *)


(**
 *
 *  Name:         function getc_usq : integer
 *  Description:  unsqueeze
 *  Parameters:   none
 *  Returns:      unsqueezed char
 *
**)
function getc_usq : integer;
label
  exit;
var
  i : integer;
begin
  i := 0;

  while i >= 0 do
    begin
      bpos := bpos + 1;

      if bpos > 7 then
        begin
          curin := getc_unp;

          if curin = ERROR then
            begin
              getc_usq := ERROR;
              goto exit                   (******** was "exit" ************)
            end;

          bpos := 0;

          i := node[i].child[1 and curin]
        end
      else
        begin
          curin := curin shr 1;
          i := node[i].child[1 and curin]
        end
    end; (* while *)

  i := - (i + 1);

  if i = SPEOF then
    getc_usq := -1
  else
    getc_usq := i;

  exit:
end; (* func getc_usq *)


end.

